qui {

noi {
	/*************************************************/
	/*** Step 2.7.1. Motivating example 		    **/
	/*************************************************/
}


/* 2.6.1.0. Visual intuition */
	
	* Simulate data
	clear all 
	set obs 100
	gen i = _n
	gen i_2 = _n
	gen PTDIDD = -1 if i == 1
	gen PTDIDD_2 = -1 if i == 1
	local p25_1 = invttail(499,.025)
	local p975_1 =  invttail(499,.975)
	local p25_2 = -1+invttail(499,.025)
	local p975_2 =  -1+invttail(499,.975)
	local p975_3 =  -2.5+invttail(499,.025)
	local p975_4 =  -1.5+invttail(499,.025)

	cd ..
	cd ".\5. TeX results"
	twoway 	(function y = tden(500,x), range(-4 4) lcolor(gs0)) ///
			(function y = tden(500,x+1), range(-4 4) lcolor(gs10) lpattern(dash))	///
			, xlab(none, value) xlab(0 "0", add labcolor(gs0)) xlab(-1 "{bf:{&beta}{subscript:s}{superscript:PL}}", add custom labcolor(gs10)) xlab(-2.5 "{bf:{&beta}{sub:s}}", add custom labcolor(red)) xline(-2.5, lc(red) lw(thick)) xline(`p25_1' `p975_1', lcolor(gs0)) xline(`p25_2' `p975_2', lcolor(gs10) lpattern(dash)) bgcolor(white) graphregion(color(white)) legend(order(1 "Placebo effect (scenario 1)" 2 "Placebo effect (scenario 2)") rows(1)) ytitle("Fraction of placebo estimates", size(large)) xtitle("(Placebo) independence dividend estimate", size(large))
	graph export figure9_1.pdf, replace
	
	twoway 	(function y = tden(500,x+2.5), range(-4 4) lc(gs0)) ///
			(function y = tden(500,x+1.5), range(-4 4) lc(gs10) lp(dash)) ///
			, xlab(none, value) xlab(0 "0", add labcolor(gs0)) xlab(-2.5 "{bf:{&beta}{sub:s}}", add custom labcolor(gs0)) xlab(-1.5 "{bf:({&beta}{subscript:s}-{&beta}{subscript:s}{superscript:PL})}", add custom labcolor(gs10)) xline(-1.5, lc(gs10) lw(thick) lp(dash)) xline(-2.5, lc(gs0) lw(thick)) xline(`p975_3', lcolor(gs0)) xline(`p975_4', lcolor(gs10) lp(dash)) bgcolor(white) graphregion(color(white)) legend(order(1 "Uncorrected estimate" 2 "Corrected estimate") rows(1)) ytitle("Fraction of placebo estimates", size(large)) xtitle("Placebo independence dividend estimate", size(large))
	graph export figure9_2.pdf, replace
	cd ..
	
	/* 2.6.1.1. Show implications for motivating example */
	cd ".\4. Master data"
	clear all
	use master_data
		
		* Motivating example 3: p-values
		sum cntrycode if cntry == "Ukraine"
		local example = r(mean)
		
		* Identify example
		noi list cntry year mother_country_name if independence_years == 0 & cntrycode == `example'

		* Load (placebo) independence gaps
		clear all
		cd ..
		cd ".\3. Intermediary results\3.4. Intermediaries" 	
		use PIDD1_`example', clear
		cd ..
		cd ..
		
		* Generate placebo-independence years
		gen pindependence_years = .
		foreach year of numlist $startyear / 2016 {
			sum independence_years if year == `year' & cntrycode == `example'
			cap replace pindependence_years = `r(mean)' if year == `year'
			}
			
		* generate placebo country codes
		gen pcntrycode = cntrycode if cntrycode == `example'
		replace pcntrycode = 1000*`example'+cntrycode if cntrycode != `example'
		
		* Generate (placebo) independence dividends
		gen PTDIDD = .
		levelsof pcntrycode if lgap_`example' != ., local(countries)	
		foreach cntry in `countries' {
			sum lgap_`example' if pindependence_years >= -10 & pindependence_years <= -1 & pcntrycode == `cntry'
			replace PTDIDD = lgap_`example'-`r(mean)' if pcntrycode == `cntry'
			}
		
		* Plot full-trajectory CI's
		gen PTTDIDD = .
		gen PTTDDIDD_ll = .
		gen PTTDDIDD_ul = .

		foreach year of numlist -10/30 {
			sum PTDIDD if pindependence_years == `year' & pcntrycode > 400
			cap replace PTTDIDD = PTDIDD-`r(mean)' if pindependence_years == `year' & pcntrycode == `example'
			cap replace PTTDDIDD_ll = PTTDIDD+invttail((`r(N)'-1),.975)*`r(sd)' if pindependence_years == `year' & cntrycode == `example'
			cap replace PTTDDIDD_ul = PTTDIDD+invttail((`r(N)'-1),.025)*`r(sd)' if pindependence_years == `year' & cntrycode == `example'
			}
			
		* Plot aggregate (raw) independence dividend estimates + 95% CI
		sort pindependence_years
		
		gen refline = 0
		twoway 	(rarea PTTDDIDD_ll PTTDDIDD_ul pindependence_years, astyle(ci2) acolor(gs14)) || ///
				(line refline independence_years, lcolor(red)) || ///
				(connected PTTDIDD independence_years, lcolor(gs0) mlcolor(gs0) mfcolor(gs0) msymbol(O)) || ///
				if independence_years >= -10 & independence_years <= 30 & cntrycode == `example' || ///
				, legend(off) ytitle("Independence dividend", size(large)) xtitle("Years of independence", size(large)) xline(0, lcolor(red) lpattern(dot) lstyle(foreground)) yline(0, lstyle(foreground) lcolor(gs0) lpattern(dot)) graphregion(color(white)) bgcolor(white) ///
				note("with 95% confidence interval")
		cd ".\5. TeX results"
		graph export figure10_2.pdf, replace
		cd ..
		
		* Reroute to directory containing dofiles
		cd ".\1. Dofiles"
		}
